/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.database.jdbc;

import ibm.nways.jdm.database.jdbc.DbJdbcColumn;
import ibm.nways.jdm.database.jdbc.DbJdbcColumnSet;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class DbJdbcSort
implements Serializable {
    private static ResourceBundle strings = ResourceBundle.getBundle("ibm.nways.jdm.database.jdbc.DbJdbcResources");
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    private static final int FIRST_ORDER = 0;
    private static final int LAST_ORDER = 1;
    protected DbJdbcColumnSet columns;
    protected int order = 0;

    public DbJdbcSort(DbJdbcColumnSet dbJdbcColumnSet) {
        this.columns = dbJdbcColumnSet;
    }

    public void setOrder(int n) throws IllegalArgumentException {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.order = n;
    }

    public static String getOrderString(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = strings.getString("ASCENDING");
                break;
            }
            case 1: {
                string = strings.getString("DESCENDING");
                break;
            }
        }
        return string;
    }

    public static Vector getAllOrders() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n <= 1) {
            vector.addElement(strings.getString(DbJdbcSort.getOrderString(n)));
            ++n;
        }
        return vector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ORDER BY ");
        DbJdbcColumn dbJdbcColumn = null;
        Enumeration enumeration = this.columns.getColumns();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            dbJdbcColumn = (DbJdbcColumn)enumeration.nextElement();
            stringBuffer.append(dbJdbcColumn.getName());
        }
        if (this.order == 1) {
            stringBuffer.append(" DESC");
        }
        return stringBuffer.toString();
    }
}

